<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckInstalled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // If the route is already the installation route, proceed
        if ($request->is('install*')) {
            return $next($request);
        }

        // Check if the application is marked as installed
        if (env('APP_INSTALLED') !== true) {
             return redirect()->route('install.index');
        }

        return $next($request);
    }
}
