<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Media Table
        Schema::create('media', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['anime', 'tv', 'movie']);
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('poster_path')->nullable(); // Image URL
            $table->boolean('is_dub')->default(false); // Critical for Anime
            $table->json('metadata')->nullable(); // External IDs (Simkl, TMDB, MAL)
            $table->timestamps();
        });

        // Settings Table (Key-Value Store)
        Schema::create('settings', function (Blueprint $table) {
            $table->string('key')->primary();
            $table->text('value')->nullable();
            $table->timestamps();
        });

        // Update Users Table for EnsoWatchList specific fields
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'is_admin')) {
                $table->boolean('is_admin')->default(false);
            }
            if (!Schema::hasColumn('users', 'vip_status')) {
                $table->boolean('vip_status')->default(false);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('media');
        Schema::dropIfExists('settings');
        
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['is_admin', 'vip_status']);
        });
    }
};
