@extends('layouts.admin')

@section('title', 'Dashboard')
@section('header', 'Overview')

@section('content')
    <!-- Stat Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Users Card -->
        <div class="bg-white rounded-lg shadow-sm p-5 border border-gray-100">
            <div class="flex items-center">
                <div class="flex-shrink-0 p-3 rounded-full bg-indigo-50 text-indigo-600">
                    <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                </div>
                <div class="ml-4">
                    <h2 class="text-sm font-medium text-gray-500 uppercase tracking-wide">Total Users</h2>
                    <p class="text-2xl font-bold text-gray-900">{{ $stats['users'] }}</p>
                </div>
            </div>
        </div>

        <!-- Media Count -->
        <div class="bg-white rounded-lg shadow-sm p-5 border border-gray-100">
            <div class="flex items-center">
                <div class="flex-shrink-0 p-3 rounded-full bg-pink-50 text-pink-600">
                   <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4v16M17 4v16M3 8h4m10 0h4M3 12h18M3 16h4m10 0h4M4 20h16a1 1 0 001-1V5a1 1 0 00-1-1H4a1 1 0 00-1 1v14a1 1 0 001 1z"></path></svg>
                </div>
                <div class="ml-4">
                    <h2 class="text-sm font-medium text-gray-500 uppercase tracking-wide">Total Media</h2>
                    <p class="text-2xl font-bold text-gray-900">{{ $stats['media'] }}</p>
                </div>
            </div>
        </div>

        <!-- System Status -->
         <div class="bg-white rounded-lg shadow-sm p-5 border border-gray-100">
            <div class="flex items-center">
                <div class="flex-shrink-0 p-3 rounded-full bg-green-50 text-green-600">
                    <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <div class="ml-4">
                    <h2 class="text-sm font-medium text-gray-500 uppercase tracking-wide">System Status</h2>
                    <p class="text-sm font-bold text-green-600">Operational</p>
                    <p class="text-xs text-gray-400">PHP {{ $system['php'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Quick Actions -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="text-lg font-medium text-gray-900">Setup Wizards (Coming Soon)</h3>
            </div>
            <div class="p-5 grid grid-cols-1 gap-4">
                <button class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition duration-150">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 h-10 w-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-500">
                            <span class="font-bold">TMDB</span>
                        </div>
                        <div class="ml-4">
                            <h4 class="text-sm font-medium text-gray-900">Configure Metadata</h4>
                            <p class="text-xs text-gray-500">Connect to TMDB/TVDB API</p>
                        </div>
                    </div>
                    <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                </button>

                 <button class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition duration-150">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 h-10 w-10 rounded-full bg-yellow-100 flex items-center justify-center text-yellow-600">
                            <span class="font-bold">PLEX</span>
                        </div>
                        <div class="ml-4">
                            <h4 class="text-sm font-medium text-gray-900">Connect Media Server</h4>
                            <p class="text-xs text-gray-500">Setup Plex/Jellyfin Webhooks</p>
                        </div>
                    </div>
                    <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                </button>
            </div>
        </div>

        <!-- Recent Users -->
         <div class="bg-white rounded-lg shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="text-lg font-medium text-gray-900">Newest Users</h3>
            </div>
            <ul class="divide-y divide-gray-100">
                @foreach($stats['recent_users'] as $user)
                    <li class="p-5 flex items-center justify-between">
                         <div class="flex items-center">
                             <img class="h-8 w-8 rounded-full" src="https://ui-avatars.com/api/?name={{ urlencode($user->name) }}&background=random" alt="">
                             <div class="ml-3">
                                 <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                                 <p class="text-xs text-gray-500">{{ $user->email }}</p>
                             </div>
                         </div>
                         <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                             Active
                         </span>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@endsection
