@extends('layouts.admin')

@section('title', 'Media Library')
@section('header', 'Media Library')

@section('content')
<div class="bg-white px-4 py-5 border-b border-gray-200 sm:px-6 mb-6 rounded-lg shadow-sm flex items-center justify-between">
    <h3 class="text-lg leading-6 font-medium text-gray-900">Library Content</h3>
    <button type="button" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none">
        Add New +
    </button>
</div>

@if($media->count() > 0)
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-6">
        @foreach($media as $item)
            <div class="bg-white rounded-lg shadow overflow-hidden hover:shadow-md transition-shadow">
                <img class="w-full h-48 object-cover" src="{{ $item->poster_path ?? 'https://via.placeholder.com/300x450?text=No+Image' }}" alt="{{ $item->title }}">
                <div class="p-4">
                    <h4 class="text-sm font-bold text-gray-900 truncate" title="{{ $item->title }}">{{ $item->title }}</h4>
                    <div class="flex items-center justify-between mt-2">
                        <span class="px-2 py-0.5 rounded text-xs font-medium 
                            {{ $item->type === 'anime' ? 'bg-pink-100 text-pink-800' : ($item->type === 'movie' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800') }}">
                            {{ ucfirst($item->type) }}
                        </span>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
    
     <div class="mt-6">
        {{ $media->links() }}
    </div>
@else
    <div class="text-center py-20 bg-white rounded-lg border-2 border-dashed border-gray-300">
        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4v16M17 4v16M3 8h4m10 0h4M3 12h18M3 16h4m10 0h4M4 20h16a1 1 0 001-1V5a1 1 0 00-1-1H4a1 1 0 00-1 1v14a1 1 0 001 1z"></path></svg>
        <h3 class="mt-2 text-sm font-medium text-gray-900">No media found</h3>
        <p class="mt-1 text-sm text-gray-500">Get started by adding new items or syncing with TMDB.</p>
        <div class="mt-6">
            <button type="button" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none">
                <svg class="-ml-1 mr-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                </svg>
                Create Media
            </button>
        </div>
    </div>
@endif
@endsection
