@extends('layouts.admin')

@section('title', 'Settings')
@section('header', 'General Settings')

@section('content')
<div class="bg-white shadow overflow-hidden sm:rounded-lg">
    <div class="px-4 py-5 sm:px-6">
        <h3 class="text-lg leading-6 font-medium text-gray-900">Application Configuration</h3>
        <p class="mt-1 max-w-2xl text-sm text-gray-500">Manage global settings for your instance.</p>
    </div>
    <div class="border-t border-gray-200 px-4 py-5 sm:p-0">
        <dl class="divide-y divide-gray-200">
             <!-- Site Name -->
            <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                <dt class="text-sm font-medium text-gray-500">Site Name</dt>
                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">EnsoWatchList</dd>
            </div>
            
             <!-- Allow Registration -->
            <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                <dt class="text-sm font-medium text-gray-500">Allow Registration</dt>
                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                    <span class="bg-green-100 text-green-800 px-2 inline-flex text-xs leading-5 font-semibold rounded-full">Enabled</span>
                </dd>
            </div>

            <!-- TMDB API Key -->
            <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                <dt class="text-sm font-medium text-gray-500">TMDB API Connection</dt>
                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                     <span class="bg-red-100 text-red-800 px-2 inline-flex text-xs leading-5 font-semibold rounded-full">Not Configured</span>
                     <button class="ml-4 text-indigo-600 hover:text-indigo-900 text-sm font-medium">Configure</button>
                </dd>
            </div>

             <!-- Simkl Sync -->
            <div class="py-4 sm:py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                <dt class="text-sm font-medium text-gray-500">Simkl Account Sync</dt>
                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                     <span class="bg-gray-100 text-gray-800 px-2 inline-flex text-xs leading-5 font-semibold rounded-full">Disabled</span>
                     <button class="ml-4 text-indigo-600 hover:text-indigo-900 text-sm font-medium">Connect</button>
                </dd>
            </div>
        </dl>
    </div>
</div>
@endsection
