@extends('layouts.app')

@section('title', 'Run Migrations')

@section('content')
    <div>
        <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">Database Ready</h2>
        <p class="mt-2 text-center text-sm text-gray-600">
            Click below to build the database structure.
        </p>
    </div>

    <form class="mt-8 space-y-6" action="{{ route('install.step3.post') }}" method="POST">
        @csrf
        
        <div class="rounded-md bg-blue-50 p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                    </svg>
                </div>
                <div class="ml-3 flex-1 md:flex md:justify-between">
                    <p class="text-sm text-blue-700">
                        This process may take a few seconds.
                    </p>
                </div>
            </div>
        </div>

        <div>
            <button type="submit" class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Run Migrations
            </button>
        </div>
    </form>
@endsection
