@extends('layouts.app')

@section('title', 'Requirements Check')

@section('content')
    <div>
        <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">System Requirements</h2>
        <p class="mt-2 text-center text-sm text-gray-600">
            Checking if your server is ready.
        </p>
    </div>

    <div class="mt-8 space-y-4">
        @foreach($results as $type => $status)
            <div class="flex items-center justify-between p-3 rounded-md {{ $status ? 'bg-green-50 text-green-700' : 'bg-red-50 text-red-700' }}">
                <span class="font-medium capitalize">{{ $type }}</span>
                <span>
                    @if($status)
                        <svg class="h-5 w-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                    @else
                        <svg class="h-5 w-5 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                    @endif
                </span>
            </div>
        @endforeach

        <h3 class="mt-4 text-lg font-medium text-gray-900">Directory Permissions</h3>
        @foreach($permissions as $path => $status)
            <div class="flex items-center justify-between p-3 rounded-md {{ $status ? 'bg-green-50 text-green-700' : 'bg-red-50 text-red-700' }}">
                <span class="font-medium">{{ $path }}</span>
                <span>
                    @if($status)
                        <span class="text-xs font-bold mr-2">Writable</span>
                        <svg class="h-5 w-5 text-green-500 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                    @else
                        <span class="text-xs font-bold mr-2">Not Writable</span>
                        <svg class="h-5 w-5 text-red-500 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                    @endif
                </span>
            </div>
        @endforeach

        @if(!in_array(false, $results) && !in_array(false, $permissions))
            <div class="mt-6">
                <a href="{{ route('install.step2') }}" class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Next Step: Database
                </a>
            </div>
        @else
            <div class="mt-6 text-center text-red-600 font-bold">
                Please fix the issues above to continue.
            </div>
        @endif
    </div>
@endsection
