@extends('layouts.user')

@section('title', 'My WatchList')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    
    <!-- Stats Row -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
        <div class="bg-gray-800 rounded-xl p-4 border border-gray-700">
            <div class="text-gray-400 text-xs uppercase font-semibold">Watching</div>
            <div class="text-2xl font-bold text-white mt-1">12</div>
        </div>
        <div class="bg-gray-800 rounded-xl p-4 border border-gray-700">
            <div class="text-gray-400 text-xs uppercase font-semibold">Completed</div>
            <div class="text-2xl font-bold text-white mt-1">148</div>
        </div>
        <div class="bg-gray-800 rounded-xl p-4 border border-gray-700">
            <div class="text-gray-400 text-xs uppercase font-semibold">Plan to Watch</div>
            <div class="text-2xl font-bold text-white mt-1">34</div>
        </div>
        <div class="bg-gray-800 rounded-xl p-4 border border-gray-700">
            <div class="text-gray-400 text-xs uppercase font-semibold">Episodes Watched</div>
            <div class="text-2xl font-bold text-indigo-400 mt-1">2,405</div>
        </div>
    </div>

    <!-- Main List Area -->
    <div class="bg-gray-800 rounded-xl shadow-xl overflow-hidden border border-gray-700 min-h-[500px]">
        <!-- Tabs -->
        <div class="border-b border-gray-700">
            <nav class="-mb-px flex" aria-label="Tabs">
                <a href="#" class="border-b-2 border-indigo-500 w-1/4 py-4 px-1 text-center text-sm font-medium text-indigo-400">
                    All Items
                </a>
                <a href="#" class="border-b-2 border-transparent w-1/4 py-4 px-1 text-center text-sm font-medium text-gray-400 hover:text-gray-300 hover:border-gray-300">
                    Watching
                </a>
                 <a href="#" class="border-b-2 border-transparent w-1/4 py-4 px-1 text-center text-sm font-medium text-gray-400 hover:text-gray-300 hover:border-gray-300">
                    Completed
                </a>
                 <a href="#" class="border-b-2 border-transparent w-1/4 py-4 px-1 text-center text-sm font-medium text-gray-400 hover:text-gray-300 hover:border-gray-300">
                    Plan to Watch
                </a>
            </nav>
        </div>

        <!-- Empty State (since DB is fresh) -->
        <div class="flex flex-col items-center justify-center py-20 text-center">
            <div class="bg-gray-700 rounded-full p-6 mb-4">
                <svg class="h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
            </div>
            <h3 class="text-xl font-medium text-white mb-2">Your list is empty</h3>
            <p class="text-gray-400 mb-6 max-w-sm">
                Start tracking your TV shows, anime, and movies. Add items to see them here.
            </p>
            <button class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 transition duration-150">
                <svg class="h-5 w-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
                Browse Media
            </button>
        </div>
    </div>
</div>
@endsection
